<?php
/* @var $this MainController */

?>

<?php if (empty($firma->bank)) : ?>

<div style="display:table;width:100%;height:100%;">
	<div style="display:table-row">
		<div style="display:table-cell;vertical-align:middle;text-align:center">
			By dokonywać płatności wybierz najpierw jeden z banków.
		</div>
	</div>
</div>

<?php else :
	$imie = Yii::app()->user->name;
	$nazwisko = Yii::app()->user->nazwisko;
?>

<style type="text/css">
	.laptopBankingHead {
		background: #aebcbf; /* Old browsers */
		background: -moz-linear-gradient(top,  #aebcbf 0%, #6e7774 50%, #0a0e0a 51%, #0a0809 100%); /* FF3.6+ */
		background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#aebcbf), color-stop(50%,#6e7774), color-stop(51%,#0a0e0a), color-stop(100%,#0a0809)); /* Chrome,Safari4+ */
		background: -webkit-linear-gradient(top,  #aebcbf 0%,#6e7774 50%,#0a0e0a 51%,#0a0809 100%); /* Chrome10+,Safari5.1+ */
		background: -o-linear-gradient(top,  #aebcbf 0%,#6e7774 50%,#0a0e0a 51%,#0a0809 100%); /* Opera 11.10+ */
		background: -ms-linear-gradient(top,  #aebcbf 0%,#6e7774 50%,#0a0e0a 51%,#0a0809 100%); /* IE10+ */
		background: linear-gradient(to bottom,  #aebcbf 0%,#6e7774 50%,#0a0e0a 51%,#0a0809 100%); /* W3C */
		filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#aebcbf', endColorstr='#0a0809',GradientType=0 ); /* IE6-9 */
		color: white;
		padding: 4px;
	}
	.laptopBankingTitle {
		font-size:34pt;
		width: 100%;
		line-height: 36pt;
		color: #0a0a0a;
	}
	.laptopBankingTitle img {
		height: 100px;
		vertical-align: middle;
	}
	.laptopBankingHr, .laptopBankingTitle {
		background: #c5deea; /* Old browsers */
		background: -moz-linear-gradient(top,  #c5deea 0%, #8abbd7 31%, #066dab 100%); /* FF3.6+ */
		background: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#c5deea), color-stop(31%,#8abbd7), color-stop(100%,#066dab)); /* Chrome,Safari4+ */
		background: -webkit-linear-gradient(top,  #c5deea 0%,#8abbd7 31%,#066dab 100%); /* Chrome10+,Safari5.1+ */
		background: -o-linear-gradient(top,  #c5deea 0%,#8abbd7 31%,#066dab 100%); /* Opera 11.10+ */
		background: -ms-linear-gradient(top,  #c5deea 0%,#8abbd7 31%,#066dab 100%); /* IE10+ */
		background: linear-gradient(to bottom,  #c5deea 0%,#8abbd7 31%,#066dab 100%); /* W3C */
		filter: progid:DXImageTransform.Microsoft.gradient( startColorstr='#c5deea', endColorstr='#066dab',GradientType=0 ); /* IE6-9 */
	}
	.laptopBankingHr {
		padding: 4px;
	}
	.laptopBankingMenus {
		width: 180px;
		float: left;
	}
	.laptopBankingMenus fieldset {
		margin: 8px;
		border: 1px solid silver;
		padding: 8px;
		border-radius: 4px;
	}
	.laptopBankingMenus legend {
		padding: 2px;
		font-weight: bold;
	}
	.laptopBankingMenus ul {
		margin: 0;
		padding: 0;
	}
	.laptopBankingMenus li {
		margin: 0;
		padding: 0;
		list-style-type: none;
	}
	.laptopBankingContent {
		margin-left: 190px;
		padding: 4px;
	}
	.laptopBankingFooter {
		border-top: 1px solid silver;
		border-bottom: 1px solid silver;
		text-align: center;
		margin-top: 5px;
		margin-bottom: 5px;
		clear: both;
	}
	#laptopBankingPrzelewyTab, #laptopBankingDodajTab {
		display: none;
	}
	#laptopBankingPrzelewyTab tr:nth-child(even) {
		background: #CCC
	}
	#laptopBankingDodajTab label {
		display: inline-block;
	}
	.laptopBankingHr {
		color: black;
	}
	.disabled {
		color: gray;
	}
</style>

<div class="laptopBankingHead">
	Bankowość internetowa
	<span style="float:right">Witaj <?php echo $imie . ' ' . $nazwisko; ?>!</span>
</div>
<div class="laptopBankingTitle">
	<img src="<?php echo Yii::app()->baseUrl; ?>/images/loga/loga_banki/<?php echo strtolower($firma->bank->nazwa); ?>.png" /> <?php echo $firma->bank->opis; ?>
</div>
<div class="laptopBankingHr">
	Home
</div>
<div>
	<div class="laptopBankingMenus">
		<fieldset>
			<legend>Menu</legend>
			<ul>
				<li><a id="laptopBankingLinkHome" href="#laptopBankingHomeTab">Home</a></li>
				<li><a id="laptopBankingLinkRachunek" href="#laptopBankingPrzelewyTab">Historia</a></li>
				<li><a id="laptopBankingLinkprzelew" href="#laptopBankingDodajTab">Dokonaj przelewu</a></li>
			</ul>
		</fieldset>
	</div>
	<div class="laptopBankingContent">
		<div id="laptopBankingHomeTab">
			<b>Firma</b>: <?php echo $firma->nazwa; ?><br/>
			<b>Rachunek</b>: 77 1030 0000 0000 0000 0000 0000<br/>
			<b>Stan konta</b>: <span id="laptopBankingStanKonta"><?php echo $firma->stanKontaFormatted; ?></span> zł<br/>
		</div>
		<div id="laptopBankingPrzelewyTab">
			<table style="width:100%">
				<thead>
					<tr>
						<th>Do/Od</th>
						<th>Tytułem</th>
						<th>Wartość</th>
						<th>Zaksięgowano</th>
					</tr>
				</thead>
				<tbody>
					<?php foreach ($oplaty as $oplata) : ?>
					<tr>
						<td><?php echo $oplata->target; ?></td>
						<td><?php echo $oplata->tytul; ?></td>
						<td><?php echo $oplata->wartosc < 0 ? '<span style="color:red">' .number_format($oplata->wartosc, 2, '.', ''). ' zł</span>' : number_format($oplata->wartosc, 2, '.', '').' zł'; ?></td>
						<td><?php echo empty($oplata->czas) ? 'Nie' : $oplata->czasYmd; ?></td>
					</tr>
					<?php	endforeach; ?>
				</tbody>
			</table>
		</div>
		<div id="laptopBankingDodajTab">
			<div id="transfer_all_error" style="display:none;color:red"></div>
			<div style="display:table">
				<div style="display:table-row">
					<div style="display:table-cell"><?php echo CHtml::label('Do', 'transfer[idKontrahenta]'); ?></div>
					<div style="display:table-cell">
						<?php echo CHtml::dropDownList('transfer[idKontrahenta]', '', $kontrahenci); ?>
						<div id="transfer_idKontrahenta_error" style="display:none;color:red"></div>
					</div>
				</div>
				<div style="display:table-row">
					<div style="display:table-cell"><?php echo CHtml::label('Tytułem', 'transfer[tytul]'); ?></div>
					<div style="display:table-cell">
						<?php echo CHtml::textField('transfer[tytul]','',array('style'=>'width: 300px')) ?>
						<div id="transfer_tytul_error" style="display:none;color:red"></div>
					</div>
				</div>
				<div style="display:table-row">
					<div style="display:table-cell"><?php echo CHtml::label('Wartość', 'transfer[wartosc]'); ?></div>
					<div style="display:table-cell">
						<div><?php echo CHtml::textField('transfer[wartosc]','0',array('disabled'=>'disabled')); ?> zł</div>
						<div id="transfer_wartosc_error" style="display:none;color:red"></div>
					</div>
				</div>
			</div>
			<div>
				<?php echo CHtml::button('Wyślij', array('id'=>'laptopBankingSendTransfer', 'style'=>'background-color: #0eb836; 
				color: white; width: 100px; font-weight: bold; font-size: 20px; -webkit-border-radius: 15px; -moz-border-radius: 15px; border-radius: 15px;')); ?>
			</div>
		</div>
	</div>
</div>
<div class="laptopBankingFooter">
	Copyright (c) 2013 <?php echo $firma->bank->opis; ?>. All rights reserved.
</div>

<?php echo CHtml::scriptFile(Yii::app()->getModule('student')->getAssetsUrl().'/js/gui/interior/banking.js'); ?>

<?php endif; ?>
